/*! \file tlk_sclk_api_defs.h 
**********************************************************************************
*Title:                         Discretix Secured Clock Toolkit header file
*
* Filename:                     tlk_sclk_api_defs.h 
*
* Project, Target, subsystem:   Toolkit, Secured Clock
* 
* Created:                      10.09.2008
*
* Modified:                     10.09.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_SCLK_API_DEFS_H_
#define _TLK_SCLK_API_DEFS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "tlk_sclk_api_config.h"

#define TLK_SCLK_TAMPER_EVIDENCE_COOKIE_SIZE_IN_BYTES       (4)

#define TLK_SCLK_NUMBER_OF_TRUSTED_APPLICATIONS             (4)

#define TLK_SCLK_APPLICATION_ID_SIZE_IN_BYTES               (4)
    
#define TLK_SCLK_MAC_LENGTH_IN_BYTES                        (20)

#define TLK_SCLK_CLOCK_DRIFT_RATE_NO_DRIFT                  (0)

#define TLK_SCLK_CLOCK_DRIFT_RATE_DEFAULT                   (1000000)

#define TLK_SCLK_CLOCK_VALIDITY_LINIT_UNLIMITED             (0x7FFFFFFF)

#define TLK_SCLK_CLOCK_PARAM_UPDATE_PERIOD_IN_SEC_DEAFULT   (0)

#define TLK_SCLK_MASTER_CLOCK_COOKIE_DAFULT                 (0xBB)

#define TLK_SCLK_MIN_WORKSPACE_IN_SIZE_IN_BYTES             (1024)

#define TLK_SCLK_MAX_PWD_LEN_IN_BYTES						(256)

#define TLK_SCLK_WORD_ALLIGN(arg)                                                           \
    /*lint -save -e778*/                                           \
    ((((DxUint32_t)(arg)) & (0x3)) ?                                \
    (((((DxUint32_t)(arg))>>(2))+1)<<(2)) : ((DxUint32_t)(arg)))    \
    /*lint -restore */

#define TLK_SCLK_IS_ACTIVE					(DX_TRUE == g_TLK_SCLK_GlobalVars.isActive)

#if TLK_SCLK_TEST_REAL_WORLD_RUN
#define TLK_SCLK_MC_PARAM_UPDATE_PERIOD_IN_SEC_DEFAULT      (604800)   /* One week */
#else
#define TLK_SCLK_MC_PARAM_UPDATE_PERIOD_IN_SEC_DEFAULT      (60)       /* One minute */
#endif

#ifdef __cplusplus
}
#endif /*extern "C"*/

#endif /*_TLK_SCLK_API_DEFS_H_*/

